# ad9361

set_property  -dict {PACKAGE_PIN  K5    IOSTANDARD LVCMOS18} [get_ports enable]                            ; ## AD9361_ENABLE
set_property  -dict {PACKAGE_PIN  F5    IOSTANDARD LVCMOS18} [get_ports txnrx]                             ; ## AD9361_TXNRX

set_property  -dict {PACKAGE_PIN  J3    IOSTANDARD LVCMOS18} [get_ports gpio_status[0]]                    ; ## AD9361_CTRL_OUT0
set_property  -dict {PACKAGE_PIN  J1    IOSTANDARD LVCMOS18} [get_ports gpio_status[1]]                    ; ## AD9361_CTRL_OUT1
set_property  -dict {PACKAGE_PIN  H2    IOSTANDARD LVCMOS18} [get_ports gpio_status[2]]                    ; ## AD9361_CTRL_OUT2
set_property  -dict {PACKAGE_PIN  G4    IOSTANDARD LVCMOS18} [get_ports gpio_status[3]]                    ; ## AD9361_CTRL_OUT3
set_property  -dict {PACKAGE_PIN  F4    IOSTANDARD LVCMOS18} [get_ports gpio_status[4]]                    ; ## AD9361_CTRL_OUT4
set_property  -dict {PACKAGE_PIN  H3    IOSTANDARD LVCMOS18} [get_ports gpio_status[5]]                    ; ## AD9361_CTRL_OUT5
set_property  -dict {PACKAGE_PIN  G1    IOSTANDARD LVCMOS18} [get_ports gpio_status[6]]                    ; ## AD9361_CTRL_OUT6
set_property  -dict {PACKAGE_PIN  G5    IOSTANDARD LVCMOS18} [get_ports gpio_status[7]]                    ; ## AD9361_CTRL_OUT7
set_property  -dict {PACKAGE_PIN  K1    IOSTANDARD LVCMOS18} [get_ports gpio_ctl[0]]                       ; ## AD9361_CTRL_IN0
set_property  -dict {PACKAGE_PIN  L1    IOSTANDARD LVCMOS18} [get_ports gpio_ctl[1]]                       ; ## AD9361_CTRL_IN1
set_property  -dict {PACKAGE_PIN  L2    IOSTANDARD LVCMOS18} [get_ports gpio_ctl[2]]                       ; ## AD9361_CTRL_IN2
set_property  -dict {PACKAGE_PIN  J4    IOSTANDARD LVCMOS18} [get_ports gpio_ctl[3]]                       ; ## AD9361_CTRL_IN3
set_property  -dict {PACKAGE_PIN  J5    IOSTANDARD LVCMOS18} [get_ports gpio_en_agc]                       ; ## AD9361_EN_AGC
set_property  -dict {PACKAGE_PIN  D4    IOSTANDARD LVCMOS18} [get_ports gpio_sync]                         ; ## AD9361_SYNC_IN
set_property  -dict {PACKAGE_PIN  K3    IOSTANDARD LVCMOS18} [get_ports gpio_resetb]                       ; ## AD9361_AD9361_RST
set_property  -dict {PACKAGE_PIN  K16   IOSTANDARD LVCMOS18} [get_ports gpio_clksel]                       ; ## AD9361_CLKSEL, not used, connect to NC pin

set_property  -dict {PACKAGE_PIN  K2    IOSTANDARD LVCMOS18  PULLTYPE PULLUP} [get_ports spi_csn]          ; ## AD9361_SPI_ENB
set_property  -dict {PACKAGE_PIN  H4    IOSTANDARD LVCMOS18} [get_ports spi_clk]                           ; ## AD9361_SPI_CLK
set_property  -dict {PACKAGE_PIN  E1    IOSTANDARD LVCMOS18} [get_ports spi_mosi]                          ; ## AD9361_SPI_DI
set_property  -dict {PACKAGE_PIN  E2    IOSTANDARD LVCMOS18} [get_ports spi_miso]                          ; ## AD9361_SPI_DO

# iic (ccbrk with loopback drives i2c back to the FPGA)

set_property  -dict {PACKAGE_PIN  W23   IOSTANDARD LVCMOS33 PULLTYPE PULLUP} [get_ports iic_scl]           ; ## not used, connect to NC pin
set_property  -dict {PACKAGE_PIN  AJ25  IOSTANDARD LVCMOS33 PULLTYPE PULLUP} [get_ports iic_sda]           ; ## not used, connect to NC pin

# ad9361

set_property  -dict {PACKAGE_PIN  H9    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_clk_in_p]       ; ## DATA_CLK_P
set_property  -dict {PACKAGE_PIN  G9    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_clk_in_n]       ; ## DATA_CLK_N
set_property  -dict {PACKAGE_PIN  C6    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_frame_in_p]     ; ## RX_FRAME_P
set_property  -dict {PACKAGE_PIN  B6    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_frame_in_n]     ; ## RX_FRAME_N
set_property  -dict {PACKAGE_PIN  J10   IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_p[0]]   ; ## RX_D0_P
set_property  -dict {PACKAGE_PIN  J9    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_n[0]]   ; ## RX_D0_N
set_property  -dict {PACKAGE_PIN  L7    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_p[1]]   ; ## RX_D1_P
set_property  -dict {PACKAGE_PIN  K7    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_n[1]]   ; ## RX_D1_N
set_property  -dict {PACKAGE_PIN  D9    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_p[2]]   ; ## RX_D2_P
set_property  -dict {PACKAGE_PIN  D8    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_n[2]]   ; ## RX_D2_N
set_property  -dict {PACKAGE_PIN  C9    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_p[3]]   ; ## RX_D3_P
set_property  -dict {PACKAGE_PIN  C8    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_n[3]]   ; ## RX_D3_N
set_property  -dict {PACKAGE_PIN  L10   IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_p[4]]   ; ## RX_D4_P
set_property  -dict {PACKAGE_PIN  L9    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_n[4]]   ; ## RX_D4_N
set_property  -dict {PACKAGE_PIN  C7    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_p[5]]   ; ## RX_D5_P
set_property  -dict {PACKAGE_PIN  B7    IOSTANDARD LVDS      DIFF_TERM TRUE} [get_ports rx_data_in_n[5]]   ; ## RX_D5_N
set_property  -dict {PACKAGE_PIN  F9    IOSTANDARD LVDS}     [get_ports tx_clk_out_p]                      ; ## FB_CLK_P
set_property  -dict {PACKAGE_PIN  E8    IOSTANDARD LVDS}     [get_ports tx_clk_out_n]                      ; ## FB_CLK_N
set_property  -dict {PACKAGE_PIN  H12   IOSTANDARD LVDS}     [get_ports tx_frame_out_p]                    ; ## TX_FRAME_P
set_property  -dict {PACKAGE_PIN  G11   IOSTANDARD LVDS}     [get_ports tx_frame_out_n]                    ; ## TX_FRAME_N
set_property  -dict {PACKAGE_PIN  E10   IOSTANDARD LVDS}     [get_ports tx_data_out_p[0]]                  ; ## TX_D0_P
set_property  -dict {PACKAGE_PIN  D10   IOSTANDARD LVDS}     [get_ports tx_data_out_n[0]]                  ; ## TX_D0_N
set_property  -dict {PACKAGE_PIN  G10   IOSTANDARD LVDS}     [get_ports tx_data_out_p[1]]                  ; ## TX_D1_P
set_property  -dict {PACKAGE_PIN  F10   IOSTANDARD LVDS}     [get_ports tx_data_out_n[1]]                  ; ## TX_D1_N
set_property  -dict {PACKAGE_PIN  E11   IOSTANDARD LVDS}     [get_ports tx_data_out_p[2]]                  ; ## TX_D2_P
set_property  -dict {PACKAGE_PIN  D11   IOSTANDARD LVDS}     [get_ports tx_data_out_n[2]]                  ; ## TX_D2_N
set_property  -dict {PACKAGE_PIN  B9    IOSTANDARD LVDS}     [get_ports tx_data_out_p[3]]                  ; ## TX_D3_P
set_property  -dict {PACKAGE_PIN  A9    IOSTANDARD LVDS}     [get_ports tx_data_out_n[3]]                  ; ## TX_D3_N
set_property  -dict {PACKAGE_PIN  J8    IOSTANDARD LVDS}     [get_ports tx_data_out_p[4]]                  ; ## TX_D4_P
set_property  -dict {PACKAGE_PIN  H8    IOSTANDARD LVDS}     [get_ports tx_data_out_n[4]]                  ; ## TX_D4_N
set_property  -dict {PACKAGE_PIN  H7    IOSTANDARD LVDS}     [get_ports tx_data_out_p[5]]                  ; ## TX_D5_P
set_property  -dict {PACKAGE_PIN  G7    IOSTANDARD LVDS}     [get_ports tx_data_out_n[5]]                  ; ## TX_D5_N

# clocks
create_clock -name rx_clk       -period  4 [get_ports rx_clk_in_p]

# PL clock
set_property -dict {PACKAGE_PIN E6      IOSTANDARD LVCMOS18}    [get_ports clk_pl]
set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets clk_pl]

# Reset in PL_GPIO_0 as RST_IN
set_property -dict {PACKAGE_PIN AF17    IOSTANDARD LVCMOS33}    [get_ports rst_in]

# PHY0 and PHY1 LED
set_property -dict {PACKAGE_PIN J6      IOSTANDARD LVCMOS18}    [get_ports phy0_led0]
#set_property -dict {PACKAGE_PIN H6      IOSTANDARD LVCMOS18}    [get_ports phy0_led1]
set_property -dict {PACKAGE_PIN L3      IOSTANDARD LVCMOS18}    [get_ports phy1_led0]
#set_property -dict {PACKAGE_PIN L5      IOSTANDARD LVCMOS18}    [get_ports phy1_led1]

# LEDs
set_property -dict {PACKAGE_PIN AJ18    IOSTANDARD LVCMOS33}    [get_ports led1]
set_property -dict {PACKAGE_PIN AJ16    IOSTANDARD LVCMOS33}    [get_ports led2]
set_property -dict {PACKAGE_PIN AJ13    IOSTANDARD LVCMOS33}    [get_ports led3]
set_property -dict {PACKAGE_PIN AJ14    IOSTANDARD LVCMOS33}    [get_ports led4]

# AD9361 GPOs, ad9361_gpo0 as txen, ad9361_gpo1 as rxen
set_property -dict {PACKAGE_PIN AA14    IOSTANDARD LVCMOS33}    [get_ports ad9361_gpo0]
set_property -dict {PACKAGE_PIN AC12    IOSTANDARD LVCMOS33}    [get_ports ad9361_gpo1]
#set_property -dict {PACKAGE_PIN AB12    IOSTANDARD LVCMOS33}    [get_ports ad9361_gpo2]
#set_property -dict {PACKAGE_PIN AC13    IOSTANDARD LVCMOS33}    [get_ports ad9361_gpo3]

# PL GPIO, use pl_gpio5 (txen) and pl_gpio6(rxen) only
set_property -dict {PACKAGE_PIN AE15    IOSTANDARD LVCMOS33}    [get_ports pl_gpio5]
set_property -dict {PACKAGE_PIN AC14    IOSTANDARD LVCMOS33}    [get_ports pl_gpio6]