#!/bin/bash -f
#*********************************************************************************************************
# Vivado (TM) v2019.1 (64-bit)
#
# Filename    : system.sh
# Simulator   : Synopsys Verilog Compiler Simulator
# Description : Simulation script for compiling, elaborating and verifying the project source files.
#               The script will automatically create the design libraries sub-directories in the run
#               directory, add the library logical mappings in the simulator setup file, create default
#               'do/prj' file, execute compilation, elaboration and simulation steps.
#
# Generated by Vivado on Mon Apr 22 15:39:43 +0800 2024
# SW Build 2552052 on Fri May 24 14:49:42 MDT 2019
#
# Copyright 1986-2019 Xilinx, Inc. All Rights Reserved. 
#
# usage: system.sh [-help]
# usage: system.sh [-lib_map_path]
# usage: system.sh [-noclean_files]
# usage: system.sh [-reset_run]
#
# Prerequisite:- To compile and run simulation, you must compile the Xilinx simulation libraries using the
# 'compile_simlib' TCL command. For more information about this command, run 'compile_simlib -help' in the
# Vivado Tcl Shell. Once the libraries have been compiled successfully, specify the -lib_map_path switch
# that points to these libraries and rerun export_simulation. For more information about this switch please
# type 'export_simulation -help' in the Tcl shell.
#
# You can also point to the simulation libraries by either replacing the <SPECIFY_COMPILED_LIB_PATH> in this
# script with the compiled library directory path or specify this path with the '-lib_map_path' switch when
# executing this script. Please type 'system.sh -help' for more information.
#
# Additional references - 'Xilinx Vivado Design Suite User Guide:Logic simulation (UG900)'
#
#*********************************************************************************************************

# Directory path for design sources and include directories (if any) wrt this path
ref_dir="."

# Override directory with 'export_sim_ref_dir' env path value if set in the shell
if [[ (! -z "$export_sim_ref_dir") && ($export_sim_ref_dir != "") ]]; then
  ref_dir="$export_sim_ref_dir"
fi

# Command line options
vlogan_opts="-full64"
vhdlan_opts="-full64"
vcs_elab_opts="-full64 -debug_pp -t ps -licqueue -l elaborate.log"
vcs_sim_opts="-ucli -licqueue -l simulate.log"

# Design libraries
design_libs=(xilinx_vip xil_defaultlib xpm axi_infrastructure_v1_1_0 axi_vip_v1_1_5 processing_system7_vip_v1_0_7 lib_pkg_v1_0_2 lib_cdc_v1_0_2 axi_lite_ipif_v3_0_4 interrupt_control_v3_1_4 axi_iic_v2_0_22 xlconcat_v2_1_3 proc_sys_reset_v5_0_13 util_vector_logic_v2_0_1 xlconstant_v1_1_6 util_reduced_logic_v2_0_4 smartconnect_v1_0 generic_baseblocks_v2_1_0 axi_register_slice_v2_1_19 fifo_generator_v13_2_4 axi_data_fifo_v2_1_18 axi_crossbar_v2_1_20 axi_protocol_converter_v2_1_19)

# Simulation root library directory
sim_lib_dir="vcs_lib"

# Script info
echo -e "system.sh - Script generated by export_simulation (Vivado v2019.1 (64-bit)-id)\n"

# Main steps
run()
{
  check_args $# $1
  setup $1 $2
  compile
  elaborate
  simulate
}

# RUN_STEP: <compile>
compile()
{
  # Compile design files
  vlogan -work xilinx_vip $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/axi4stream_vip_axi4streampc.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/axi_vip_axi4pc.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/xil_common_vip_pkg.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/axi4stream_vip_pkg.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/axi_vip_pkg.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/axi4stream_vip_if.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/axi_vip_if.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/clk_vip_if.sv" \
    "C:/Xilinx/Vivado/2019.1/data/xilinx_vip/hdl/rst_vip_if.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "C:/Xilinx/Vivado/2019.1/data/ip/xpm/xpm_cdc/hdl/xpm_cdc.sv" \
    "C:/Xilinx/Vivado/2019.1/data/ip/xpm/xpm_fifo/hdl/xpm_fifo.sv" \
    "C:/Xilinx/Vivado/2019.1/data/ip/xpm/xpm_memory/hdl/xpm_memory.sv" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xpm $vhdlan_opts \
    "C:/Xilinx/Vivado/2019.1/data/ip/xpm/xpm_VCOMP.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work axi_infrastructure_v1_1_0 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl/axi_infrastructure_v1_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_vip_v1_1_5 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/d4a8/hdl/axi_vip_v1_1_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work processing_system7_vip_v1_0_7 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl/processing_system7_vip_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_sys_ps7_0/sim/system_sys_ps7_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work lib_pkg_v1_0_2 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/0513/hdl/lib_pkg_v1_0_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work lib_cdc_v1_0_2 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1e/hdl/lib_cdc_v1_0_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_lite_ipif_v3_0_4 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/66ea/hdl/axi_lite_ipif_v3_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work interrupt_control_v3_1_4 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/a040/hdl/interrupt_control_v3_1_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work axi_iic_v2_0_22 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/d5df/hdl/axi_iic_v2_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/system/ip/system_axi_iic_main_0/sim/system_axi_iic_main_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xlconcat_v2_1_3 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/442e/hdl/xlconcat_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_sys_concat_intc_0/sim/system_sys_concat_intc_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work proc_sys_reset_v5_0_13 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8842/hdl/proc_sys_reset_v5_0_vh_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/system/ip/system_sys_rstgen_0/sim/system_sys_rstgen_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work util_vector_logic_v2_0_1 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/2137/hdl/util_vector_logic_v2_0_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_sys_logic_inv_0/sim/system_sys_logic_inv_0.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_axi.v" \
    "$ref_dir/../../../bd/system/ipshared/07b8/axi_sysid.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_sysid_0_0/sim/system_axi_sysid_0_0.v" \
    "$ref_dir/../../../bd/system/ipshared/51ce/sysid_rom.v" \
    "$ref_dir/../../../bd/system/ip/system_rom_sys_0_0/sim/system_rom_sys_0_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xlconstant_v1_1_6 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/66e7/hdl/xlconstant_v1_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_GND_1_0/sim/system_GND_1_0.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_addsub.v" \
    "$ref_dir/../../../bd/system/ipshared/xilinx/common/ad_data_clk.v" \
    "$ref_dir/../../../bd/system/ipshared/xilinx/common/ad_data_in.v" \
    "$ref_dir/../../../bd/system/ipshared/xilinx/common/ad_data_out.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_datafmt.v" \
    "$ref_dir/../../../bd/system/ipshared/xilinx/common/ad_dcfilter.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_dds.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_dds_1.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_dds_2.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_dds_cordic_pipe.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_dds_sine.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_dds_sine_cordic.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_iqcor.v" \
    "$ref_dir/../../../bd/system/ipshared/xilinx/common/ad_mul.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_pnmon.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_pps_receiver.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_rst.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_tdd_control.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/xilinx/axi_ad9361_cmos_if.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/xilinx/axi_ad9361_lvds_if.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_rx.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_rx_channel.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_rx_pnmon.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_tdd.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_tdd_if.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_tx.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361_tx_channel.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_adc_channel.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_adc_common.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_clock_mon.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_dac_channel.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_dac_common.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_delay_cntrl.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_tdd_cntrl.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_xfer_cntrl.v" \
    "$ref_dir/../../../bd/system/ipshared/common/up_xfer_status.v" \
    "$ref_dir/../../../bd/system/ipshared/969c/axi_ad9361.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_ad9361_0/sim/system_axi_ad9361_0.v" \
    "$ref_dir/../../../bd/system/ipshared/common/util_pulse_gen.v" \
    "$ref_dir/../../../bd/system/ipshared/abec/util_tdd_sync.v" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_tdd_sync_0/sim/system_util_ad9361_tdd_sync_0.v" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_divclk_sel_concat_0/sim/system_util_ad9361_divclk_sel_concat_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work util_reduced_logic_v2_0_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/4c94/hdl/util_reduced_logic_v2_0_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_divclk_sel_0/sim/system_util_ad9361_divclk_sel_0.v" \
    "$ref_dir/../../../bd/system/ipshared/067c/util_clkdiv.v" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_divclk_0/sim/system_util_ad9361_divclk_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_divclk_reset_0/sim/system_util_ad9361_divclk_reset_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_mem.v" \
    "$ref_dir/../../../bd/system/ipshared/d170/util_wfifo.v" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_adc_fifo_0/sim/system_util_ad9361_adc_fifo_0.v" \
    "$ref_dir/../../../bd/system/common/ad_perfect_shuffle.v" \
    "$ref_dir/../../../bd/system/ipshared/util_pack_common/pack_ctrl.v" \
    "$ref_dir/../../../bd/system/ipshared/util_pack_common/pack_interconnect.v" \
    "$ref_dir/../../../bd/system/ipshared/util_pack_common/pack_network.v" \
    "$ref_dir/../../../bd/system/ipshared/util_pack_common/pack_shell.v" \
    "$ref_dir/../../../bd/system/ipshared/a685/util_cpack2_impl.v" \
    "$ref_dir/../../../bd/system/ipshared/a685/util_cpack2.v" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_adc_pack_0/sim/system_util_ad9361_adc_pack_0.v" \
    "$ref_dir/../../../bd/system/ipshared/b8ee/sync_bits.v" \
    "$ref_dir/../../../bd/system/ipshared/b8ee/sync_data.v" \
    "$ref_dir/../../../bd/system/ipshared/b8ee/sync_event.v" \
    "$ref_dir/../../../bd/system/ipshared/b8ee/sync_gray.v" \
    "$ref_dir/../../../bd/system/ipshared/d71a/address_gray_pipelined.v" \
    "$ref_dir/../../../bd/system/ipshared/d71a/address_sync.v" \
    "$ref_dir/../../../bd/system/ipshared/d71a/util_axis_fifo.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_ad9361_adc_dma_0/sim/system_axi_ad9361_adc_dma_0_pkg.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/2d_transfer.v" \
    "$ref_dir/../../../bd/system/ipshared/common/ad_mem_asym.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/address_generator.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_burst_memory.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_regmap.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_regmap_request.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_reset_manager.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_resize_dest.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_resize_src.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_response_manager.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac_transfer.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_register_slice.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/data_mover.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/dest_axi_mm.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/dest_axi_stream.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/dest_fifo_inf.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/request_arb.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/request_generator.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/response_generator.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/response_handler.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/splitter.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/src_axi_mm.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/src_axi_stream.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/src_fifo_inf.v" \
    "$ref_dir/../../../bd/system/ipshared/ef1d/axi_dmac.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_ad9361_adc_dma_0/sim/system_axi_ad9361_adc_dma_0.v" \
    "$ref_dir/../../../bd/system/ipshared/4463/util_rfifo.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_ad9361_dac_fifo_0/sim/system_axi_ad9361_dac_fifo_0.v" \
    "$ref_dir/../../../bd/system/ipshared/7b43/util_upack2_impl.v" \
    "$ref_dir/../../../bd/system/ipshared/7b43/util_upack2.v" \
    "$ref_dir/../../../bd/system/ip/system_util_ad9361_dac_upack_0/sim/system_util_ad9361_dac_upack_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_ad9361_dac_dma_0/sim/system_axi_ad9361_dac_dma_0_pkg.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_ad9361_dac_dma_0/sim/system_axi_ad9361_dac_dma_0.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_0/sim/bd_31bd_one_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_1/sim/bd_31bd_psr_aclk_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/sc_util_v1_0_vl_rfs.sv" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/f85e/hdl/sc_mmu_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_2/sim/bd_31bd_s00mmu_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ca72/hdl/sc_transaction_regulator_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_3/sim/bd_31bd_s00tr_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/7de4/hdl/sc_si_converter_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_4/sim/bd_31bd_s00sic_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b89e/hdl/sc_axi2sc_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_5/sim/bd_31bd_s00a2s_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/sc_node_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_6/sim/bd_31bd_sawn_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_7/sim/bd_31bd_swn_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_8/sim/bd_31bd_sbn_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/7005/hdl/sc_sc2axi_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_9/sim/bd_31bd_m00s2a_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work smartconnect_v1_0 $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b387/hdl/sc_exit_v1_0_vl_rfs.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/ip/ip_10/sim/bd_31bd_m00e_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/bd_0/sim/bd_31bd.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp1_interconnect_0/sim/system_axi_hp1_interconnect_0.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_0/sim/bd_c0fd_one_0.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work xil_defaultlib $vhdlan_opts \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_1/sim/bd_c0fd_psr_aclk_0.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work xil_defaultlib $vlogan_opts -sverilog +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_2/sim/bd_c0fd_s00mmu_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_3/sim/bd_c0fd_s00tr_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_4/sim/bd_c0fd_s00sic_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_5/sim/bd_c0fd_s00a2s_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_6/sim/bd_c0fd_sarn_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_7/sim/bd_c0fd_srn_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_8/sim/bd_c0fd_m00s2a_0.sv" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/ip/ip_9/sim/bd_c0fd_m00e_0.sv" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/bd_0/sim/bd_c0fd.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_hp2_interconnect_0/sim/system_axi_hp2_interconnect_0.v" \
    "$ref_dir/../../../bd/system/ipshared/070b/axi_gpreg_clock_mon.v" \
    "$ref_dir/../../../bd/system/ipshared/070b/axi_gpreg_io.v" \
    "$ref_dir/../../../bd/system/ipshared/070b/axi_gpreg.v" \
    "$ref_dir/../../../bd/system/ip/system_axi_gpreg_0/sim/system_axi_gpreg_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work generic_baseblocks_v2_1_0 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b752/hdl/generic_baseblocks_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_register_slice_v2_1_19 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/4d88/hdl/axi_register_slice_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work fifo_generator_v13_2_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1f5a/simulation/fifo_generator_vlog_beh.v" \
  2>&1 | tee -a vlogan.log

  vhdlan -work fifo_generator_v13_2_4 $vhdlan_opts \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1f5a/hdl/fifo_generator_v13_2_rfs.vhd" \
  2>&1 | tee -a vhdlan.log

  vlogan -work fifo_generator_v13_2_4 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1f5a/hdl/fifo_generator_v13_2_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_data_fifo_v2_1_18 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/5b9c/hdl/axi_data_fifo_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_crossbar_v2_1_20 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ace7/hdl/axi_crossbar_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_xbar_0/sim/system_xbar_0.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work axi_protocol_converter_v2_1_19 $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/c83a/hdl/axi_protocol_converter_v2_1_vl_rfs.v" \
  2>&1 | tee -a vlogan.log

  vlogan -work xil_defaultlib $vlogan_opts +v2k +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ec67/hdl" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/8c62/hdl" +incdir+"$ref_dir/../../../bd/system/ipshared/ef1d" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/1ddd/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/b2d0/hdl/verilog" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ip/system_sys_ps7_0" +incdir+"$ref_dir/../../../../sdr_b1.srcs/sources_1/bd/system/ipshared/ef1d" +incdir+"C:/Xilinx/Vivado/2019.1/data/xilinx_vip/include" \
    "$ref_dir/../../../bd/system/ip/system_auto_pc_0/sim/system_auto_pc_0.v" \
    "$ref_dir/../../../bd/system/sim/system.v" \
  2>&1 | tee -a vlogan.log


  vlogan -work xil_defaultlib $vlogan_opts +v2k \
    glbl.v \
  2>&1 | tee -a vlogan.log

}

# RUN_STEP: <elaborate>
elaborate()
{
  vcs $vcs_elab_opts xil_defaultlib.system xil_defaultlib.glbl -o system_simv
}

# RUN_STEP: <simulate>
simulate()
{
  ./system_simv $vcs_sim_opts -do simulate.do
}

# STEP: setup
setup()
{
  case $1 in
    "-lib_map_path" )
      if [[ ($2 == "") ]]; then
        echo -e "ERROR: Simulation library directory path not specified (type \"./system.sh -help\" for more information)\n"
        exit 1
      fi
      create_lib_mappings $2
    ;;
    "-reset_run" )
      reset_run
      echo -e "INFO: Simulation run files deleted.\n"
      exit 0
    ;;
    "-noclean_files" )
      # do not remove previous data
    ;;
    * )
      create_lib_mappings $2
  esac

  create_lib_dir

  # Add any setup/initialization commands here:-

  # <user specific commands>

}

# Define design library mappings
create_lib_mappings()
{
  file="synopsys_sim.setup"
  if [[ -e $file ]]; then
    if [[ ($1 == "") ]]; then
      return
    else
      rm -rf $file
    fi
  fi

  touch $file

  lib_map_path=""
  if [[ ($1 != "") ]]; then
    lib_map_path="$1"
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    mapping="$lib:$sim_lib_dir/$lib"
    echo $mapping >> $file
  done

  if [[ ($lib_map_path != "") ]]; then
    incl_ref="OTHERS=$lib_map_path/synopsys_sim.setup"
    echo $incl_ref >> $file
  fi
}

# Create design library directory paths
create_lib_dir()
{
  if [[ -e $sim_lib_dir ]]; then
    rm -rf $sim_lib_dir
  fi

  for (( i=0; i<${#design_libs[*]}; i++ )); do
    lib="${design_libs[i]}"
    lib_dir="$sim_lib_dir/$lib"
    if [[ ! -e $lib_dir ]]; then
      mkdir -p $lib_dir
    fi
  done
}

# Delete generated data from the previous run
reset_run()
{
  files_to_remove=(ucli.key system_simv vlogan.log vhdlan.log compile.log elaborate.log simulate.log .vlogansetup.env .vlogansetup.args .vcs_lib_lock scirocco_command.log 64 AN.DB csrc system_simv.daidir)
  for (( i=0; i<${#files_to_remove[*]}; i++ )); do
    file="${files_to_remove[i]}"
    if [[ -e $file ]]; then
      rm -rf $file
    fi
  done

  create_lib_dir
}

# Check command line arguments
check_args()
{
  if [[ ($1 == 1 ) && ($2 != "-lib_map_path" && $2 != "-noclean_files" && $2 != "-reset_run" && $2 != "-help" && $2 != "-h") ]]; then
    echo -e "ERROR: Unknown option specified '$2' (type \"./system.sh -help\" for more information)\n"
    exit 1
  fi

  if [[ ($2 == "-help" || $2 == "-h") ]]; then
    usage
  fi
}

# Script usage
usage()
{
  msg="Usage: system.sh [-help]\n\
Usage: system.sh [-lib_map_path]\n\
Usage: system.sh [-reset_run]\n\
Usage: system.sh [-noclean_files]\n\n\
[-help] -- Print help information for this script\n\n\
[-lib_map_path <path>] -- Compiled simulation library directory path. The simulation library is compiled\n\
using the compile_simlib tcl command. Please see 'compile_simlib -help' for more information.\n\n\
[-reset_run] -- Recreate simulator setup files and library mappings for a clean run. The generated files\n\
from the previous run will be removed. If you don't want to remove the simulator generated files, use the\n\
-noclean_files switch.\n\n\
[-noclean_files] -- Reset previous run, but do not remove simulator generated files from the previous run.\n\n"
  echo -e $msg
  exit 1
}

# Launch script
run $1 $2
